/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public record ItemDescription(ImmutableList<class_2561> lines, ImmutableList<class_2561> linesOnShift, ImmutableList<class_2561> linesOnCtrl) {
    private static final Map<class_1792, Supplier<String>> CUSTOM_TOOLTIP_KEYS = new IdentityHashMap<class_1792, Supplier<String>>();

    @Nullable
    public static ItemDescription create(class_1792 item, FontHelper.Palette palette) {
        return ItemDescription.create(ItemDescription.getTooltipTranslationKey(item), palette);
    }

    @Nullable
    public static ItemDescription create(String translationKey, FontHelper.Palette palette) {
        if (!ItemDescription.canFillBuilder(translationKey + ".summary")) {
            return null;
        }
        Builder builder = new Builder(palette);
        ItemDescription.fillBuilder(builder, translationKey);
        return builder.build();
    }

    public static boolean canFillBuilder(String translationKey) {
        return class_1074.method_4663((String)translationKey);
    }

    public static void fillBuilder(Builder builder, String translationKey) {
        int i;
        String summaryKey = translationKey + ".summary";
        if (class_1074.method_4663((String)summaryKey)) {
            builder.addSummary(class_1074.method_4662((String)summaryKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!class_1074.method_4663((String)conditionKey)) break;
            builder.addBehaviour(class_1074.method_4662((String)conditionKey, (Object[])new Object[0]), class_1074.method_4662((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!class_1074.method_4663((String)controlKey)) break;
            builder.addAction(class_1074.method_4662((String)controlKey, (Object[])new Object[0]), class_1074.method_4662((String)actionKey, (Object[])new Object[0]));
        }
    }

    public static void useKey(class_1792 item, Supplier<String> supplier) {
        CUSTOM_TOOLTIP_KEYS.put(item, supplier);
    }

    public static void useKey(class_1935 item, String string) {
        ItemDescription.useKey(item.method_8389(), () -> string);
    }

    public static void referKey(class_1935 item, Supplier<? extends class_1935> otherItem) {
        ItemDescription.useKey(item.method_8389(), () -> ((class_1935)otherItem.get()).method_8389().method_7876());
    }

    public static String getTooltipTranslationKey(class_1792 item) {
        if (CUSTOM_TOOLTIP_KEYS.containsKey(item)) {
            return CUSTOM_TOOLTIP_KEYS.get(item).get() + ".tooltip";
        }
        return item.method_7876() + ".tooltip";
    }

    public ImmutableList<class_2561> getCurrentLines() {
        if (class_437.method_25442()) {
            return this.linesOnShift;
        }
        if (class_437.method_25441()) {
            return this.linesOnCtrl;
        }
        return this.lines;
    }

    public static class Builder {
        protected final FontHelper.Palette palette;
        protected final List<String> summary = new ArrayList<String>();
        protected final List<Pair<String, String>> behaviours = new ArrayList<Pair<String, String>>();
        protected final List<Pair<String, String>> actions = new ArrayList<Pair<String, String>>();

        public Builder(FontHelper.Palette palette) {
            this.palette = palette;
        }

        public Builder addSummary(String summaryLine) {
            this.summary.add(summaryLine);
            return this;
        }

        public Builder addBehaviour(String condition, String behaviour) {
            this.behaviours.add((Pair<String, String>)Pair.of((Object)condition, (Object)behaviour));
            return this;
        }

        public Builder addAction(String condition, String action) {
            this.actions.add((Pair<String, String>)Pair.of((Object)condition, (Object)action));
            return this;
        }

        public ItemDescription build() {
            boolean bl;
            String condition;
            ArrayList lines = new ArrayList();
            ArrayList<Object> linesOnShift = new ArrayList<Object>();
            ArrayList<Object> linesOnCtrl = new ArrayList<Object>();
            for (String string : this.summary) {
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent(string, this.palette));
            }
            if (!this.behaviours.isEmpty()) {
                linesOnShift.add(class_5244.field_39003);
            }
            for (Pair pair : this.behaviours) {
                condition = (String)pair.getLeft();
                String behaviour = (String)pair.getRight();
                linesOnShift.add(class_2561.method_43470((String)condition).method_27692(class_124.field_1080));
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent(behaviour, this.palette.primary(), this.palette.highlight(), 1));
            }
            for (Pair pair : this.actions) {
                condition = (String)pair.getLeft();
                String action = (String)pair.getRight();
                linesOnCtrl.add(class_2561.method_43470((String)condition).method_27692(class_124.field_1080));
                linesOnCtrl.addAll(TooltipHelper.cutStringTextComponent(action, this.palette.primary(), this.palette.highlight(), 1));
            }
            boolean hasDescription = !linesOnShift.isEmpty();
            boolean bl2 = bl = !linesOnCtrl.isEmpty();
            if (hasDescription || bl) {
                String[] holdDesc = CreateLang.translateDirect("tooltip.holdForDescription", "$").getString().split("\\$");
                String[] holdCtrl = CreateLang.translateDirect("tooltip.holdForControls", "$").getString().split("\\$");
                class_5250 keyShift = CreateLang.translateDirect("tooltip.keyShift", new Object[0]);
                class_5250 keyCtrl = CreateLang.translateDirect("tooltip.keyCtrl", new Object[0]);
                for (List list : Arrays.asList(lines, linesOnShift, linesOnCtrl)) {
                    class_5250 tabBuilder;
                    boolean ctrl;
                    boolean shift = list == linesOnShift;
                    boolean bl3 = ctrl = list == linesOnCtrl;
                    if (holdDesc.length != 2 || holdCtrl.length != 2) {
                        list.add(0, class_2561.method_43470((String)"Invalid lang formatting!"));
                        continue;
                    }
                    if (bl) {
                        tabBuilder = class_2561.method_43473();
                        tabBuilder.method_10852((class_2561)class_2561.method_43470((String)holdCtrl[0]).method_27692(class_124.field_1063));
                        tabBuilder.method_10852((class_2561)keyCtrl.method_27662().method_27692(ctrl ? class_124.field_1068 : class_124.field_1080));
                        tabBuilder.method_10852((class_2561)class_2561.method_43470((String)holdCtrl[1]).method_27692(class_124.field_1063));
                        list.add(0, tabBuilder);
                    }
                    if (hasDescription) {
                        tabBuilder = class_2561.method_43473();
                        tabBuilder.method_10852((class_2561)class_2561.method_43470((String)holdDesc[0]).method_27692(class_124.field_1063));
                        tabBuilder.method_10852((class_2561)keyShift.method_27662().method_27692(shift ? class_124.field_1068 : class_124.field_1080));
                        tabBuilder.method_10852((class_2561)class_2561.method_43470((String)holdDesc[1]).method_27692(class_124.field_1063));
                        list.add(0, tabBuilder);
                    }
                    if (!shift && !ctrl) continue;
                    list.add(hasDescription && bl ? 2 : 1, class_5244.field_39003);
                }
            }
            if (!hasDescription) {
                linesOnCtrl.clear();
                linesOnShift.addAll(lines);
            }
            if (!bl) {
                linesOnCtrl.clear();
                linesOnCtrl.addAll(lines);
            }
            return new ItemDescription((ImmutableList<class_2561>)ImmutableList.copyOf(lines), (ImmutableList<class_2561>)ImmutableList.copyOf(linesOnShift), (ImmutableList<class_2561>)ImmutableList.copyOf(linesOnCtrl));
        }
    }

    public static class Modifier
    implements TooltipModifier {
        protected final class_1792 item;
        protected final FontHelper.Palette palette;
        protected String cachedLanguage;
        protected ItemDescription description;

        public Modifier(class_1792 item, FontHelper.Palette palette) {
            this.item = item;
            this.palette = palette;
        }

        @Override
        public void modify(class_1799 stack, class_1657 player, class_1836 flags, List<class_2561> tooltip) {
            if (this.checkLocale()) {
                this.description = ItemDescription.create(this.item, this.palette);
            }
            if (this.description == null) {
                return;
            }
            tooltip.addAll(1, (Collection<class_2561>)this.description.getCurrentLines());
        }

        protected boolean checkLocale() {
            String currentLanguage = class_310.method_1551().method_1526().method_4669();
            if (!currentLanguage.equals(this.cachedLanguage)) {
                this.cachedLanguage = currentLanguage;
                return true;
            }
            return false;
        }
    }
}

